﻿using System;
using System.Drawing;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace PWS.API.Keyboard.Sample6
{
    public partial class FormMain : Form
    {
        [DllImport("user32.dll")]
        public static extern bool ShowCaret(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern bool HideCaret(IntPtr hWnd);

        [DllImport("user32.dll")]
        public static extern bool CreateCaret(IntPtr hWnd, IntPtr hBitmap, int nWidth, int nHeight);

        public FormMain()
        {
            InitializeComponent();
        }

        private void buttonShowCaret_Click(object sender, EventArgs e)
        {
            Bitmap bmpCaret = new Bitmap(PictureCaret.Image); //or bitmapFilePath
            Color backColor = bmpCaret.GetPixel(1, 1);
            bmpCaret.MakeTransparent(backColor);
            IntPtr intPtrBmpCaret = bmpCaret.GetHbitmap();
            CreateCaret(textBoxTest.Handle, intPtrBmpCaret, bmpCaret.Width, bmpCaret.Height);
            ShowCaret(textBoxTest.Handle);
        }

        private void buttonHideCaret_Click(object sender, EventArgs e)
        {
            HideCaret(textBoxTest.Handle);
        }
    }
}